/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.view.swing.component;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class JLabelTransitionedNewImage
extends JLabel {
    private static final int DELTA_TIME = 10;
    private static final int ELAPSED_TIME = 200;
    private static final int MAX_COUNT = 20;
    private Image currentImage;
    private Icon newIcon;
    private Image newImage;
    private Timer timer;
    private float alpha1;
    private float alpha2;

    public JLabelTransitionedNewImage(Icon icon) {
        super(icon);
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.currentImage == null) {
            super.setIcon(icon);
            this.currentImage = this.convertIconToImage(icon);
            return;
        }
        if (this.timer != null) {
            this.stopTransition();
        }
        this.newIcon = icon;
        this.newImage = this.convertIconToImage(icon);
        this.alpha1 = 1.0f;
        this.alpha2 = 0.0f;
        this.timer = new Timer(10, new TransitionListener());
        this.timer.start();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.currentImage == null || this.newImage == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(((AlphaComposite)g2.getComposite()).derive(this.alpha1));
        g2.drawImage(this.currentImage, 0, 0, this);
        g2.setComposite(((AlphaComposite)g2.getComposite()).derive(this.alpha2));
        g2.drawImage(this.newImage, 0, 0, this);
        g2.dispose();
    }

    private Image convertIconToImage(Icon icon) {
        return ((ImageIcon)icon).getImage();
    }

    private void stopTransition() {
        this.timer.stop();
        this.currentImage = this.newImage;
        super.setIcon(this.newIcon);
    }

    private class TransitionListener
    implements ActionListener {
        private int counter = 0;

        private TransitionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.counter >= 20) {
                JLabelTransitionedNewImage.this.stopTransition();
            } else {
                JLabelTransitionedNewImage.this.alpha1 = (20.0f - (float)this.counter) / 20.0f;
                JLabelTransitionedNewImage.this.alpha2 = (float)this.counter / 20.0f;
                JLabelTransitionedNewImage.this.repaint();
                ++this.counter;
            }
        }
    }
}

